#!/usr/bin/perl
use strict;

sub parse_command {
  my $command = shift();
  if( $command =~ /^ *all +off *$/i ) {
    return 0;
  } elsif( $command =~ /^ *delay +(\d+) *ms *$/i ) {
    my $ms = $1;
    if( $ms < 1 ) {
      die "Invalid millisecond count: $ms";
    } elsif( $ms <= 256 ) {
      return 1*256|($ms-1);
    } elsif( $ms <= 256*4 ) {
      return 2*256|(($ms>>2)-1);
    } elsif( $ms <= 256*16 ) {
      return 3*256|(($ms>>4)-1);
    } else {
      my @ret = ( 3*256|255 );
      push @ret, parse_command("delay ".($ms-256*16)."ms");
      return @ret;
    }
  } elsif( $command =~ /^ *lights *(\d+)-(\d+) *(on|off|to) *([01]{8}) *$/i ) {
    my( $first, $last, $what, $state ) = ( $1, $2, $3, $4 );
    my $set;
    if( $first == 0 && $last == 7 ) {
      $set = 0;
    } elsif( $first == 8 && $last == 15 ) {
      $set = 1;
    } elsif( $first == 16 && $last == 23 ) {
      $set = 2;
    } elsif( $first == 24 && $last == 31 ) {
      $set = 3;
    } else {
      die "Invalid light start/finish for set: $first-$last";
    }
    my $stat = 0;
    while( $state ne "" ) {
      $state =~ /^([01])(.*)$/;
      my( $num, $rest ) = ( $1, $2 );
      $stat <<= 1;
      $stat |= 1 if( $num eq "1" );
      $state = $rest;
    }
    return ($what eq "to" ? 1 : $what eq "off" ? 2 : 3)*1024|($set<<8)|$stat;
  } elsif( $command =~ /^ *lights *(\d+) *and *(\d+) *(on|off|invert) *$/i ) {
    my( $a, $b, $what ) = ( $1, $2, $3 );
    die "Invalid light index: $a" if( $a < 0 || $a >= 32 );
    die "Invalid light index: $b" if( $b < 0 || $b >= 32 );
    return ($what eq "on" ? 4 : $what eq "off" ? 5 : 7)*1024|($b<<5)|$a;
  } elsif( $command =~ /^ *light *(\d+) *(on) *and *light *(\d+) *(off) *$/i ||
           $command =~ /^ *light *(\d+) *(off) *and *light *(\d+) *(on) *$/i ) {
    my( $a, $whata, $b, $whatb ) = ( $1, $2, $3, $4 );
    die "Invalid light index: $a" if( $a < 0 || $a >= 32 );
    die "Invalid light index: $b" if( $b < 0 || $b >= 32 );
    return 6*1024|($whata eq "on" ? ($a|($b<<5)) : ($b|($a<<5)));
  } elsif( $command =~ /^ *light *(\d+) *brightness *(\d+) *$/i ) {
    my( $light, $bright ) = ( $1, $2 );
    die "Invalid light index: $light" if( $light < 0 || $light >= 32 );
    die "Invalid brightness: $bright" if( $bright < 0 || $bright > 255 );
    return 1*32*256|($light<<8)|$bright;
  } elsif( $command =~ /^ *light *(\d+) *ramp *(up|down) *over *(\d+) *ms *$/i ) {
    my( $light, $dir, $ms ) = ( $1, $2, $3 );
    die "Invalid light index: $light" if( $light < 0 || $light >= 32 );
    die "Invalid ramp time: $ms" if( $ms < 8 || $ms > 256*32 );
    print STDERR "dir=$dir ms=$ms light=$light\n";
    if( $ms <= 2048 ) {
      return ($dir eq "up" ? 2 : 3)*32*256|($light<<8)|(($ms>>3)-1);
    } elsif( $ms <= 4096 ) {
      return ($dir eq "up" ? 4 : 5)*32*256|($light<<8)|(($ms>>4)-1);
    } else {
      return ($dir eq "up" ? 6 : 7)*32*256|($light<<8)|(($ms>>5)-1);
    }
  } else {
    print $command."\n";
    die "Invalid command: $command";
  }
}

while(<STDIN>) {
  chomp();
  $_ =~ s/\r$//;
  my @cmds = parse_command($_);
  foreach my $cmd( @cmds ) {
    print STDERR "cmd = ".$cmd."\n";
    print STDOUT pack("S", $cmd);
  }
#  print pack("S" x scalar(@cmds), @cmds);
}

